

CREATE TABLE `Accounts` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(255) NOT NULL,
  `Username` varchar(255) NOT NULL,
  `Password` varchar(255) NOT NULL,
  `DisplayName` varchar(255) DEFAULT NULL,
  `Role` varchar(255) NOT NULL,
  `LastLogin` datetime DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `Accounts` VALUES('1', 'local', 'Administrator', '$2y$10$mzIHyPptbo63XZgKS0d90OIepFVlW.uJ8QMGDZhrtyh8nC713eRw2', 'Administrator', 'Administrator', '2025-02-04 13:59:54');



CREATE TABLE `AuditLogs` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Username` varchar(255) NOT NULL,
  `Type` varchar(255) NOT NULL,
  `Description` varchar(255) NOT NULL,
  `IPAddress` varchar(255) NOT NULL,
  `Timestamp` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `BlacklistLocals` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Givenname` varchar(255) NOT NULL,
  `Surname` varchar(255) NOT NULL,
  `Birthday` varchar(255) NOT NULL,
  `Nationality` varchar(255) NOT NULL,
  `IDCard` varchar(255) NOT NULL,
  `Company` varchar(255) NOT NULL,
  `Reason` text NOT NULL,
  `Notes` text NOT NULL,
  `Created` date NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `BookingHistory` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `AccessCard` varchar(255) NOT NULL,
  `FullName` varchar(255) NOT NULL,
  `ZoneLeft` varchar(255) DEFAULT NULL,
  `ZoneEntered` varchar(255) DEFAULT NULL,
  `Timestamp` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


CREATE TABLE `Identities` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Type` varchar(255) NOT NULL,
  `Rank` varchar(255) DEFAULT NULL,
  `Givenname` varchar(255) NOT NULL,
  `Surname` varchar(255) NOT NULL,
  `Birthday` varchar(255) DEFAULT NULL,
  `Image` varchar(255) DEFAULT NULL,
  `AccessCard` varchar(255) DEFAULT NULL,
  `Notes` text DEFAULT NULL,
  `IdentityIN` date DEFAULT NULL,
  `IdentityOUT` date DEFAULT NULL,
  `MilitarySecurityClearance` varchar(255) DEFAULT NULL,
  `LocalIDCard` varchar(255) DEFAULT NULL,
  `LocalEmployeeID` varchar(255) DEFAULT NULL,
  `LocalSafetyBriefing` varchar(255) DEFAULT NULL,
  `LocalSafetySurvey` varchar(255) DEFAULT NULL,
  `LocalBAMADID` varchar(255) DEFAULT NULL,
  `LocalBAMADDelivery` varchar(255) DEFAULT NULL,
  `LocalBAMADResult` varchar(255) DEFAULT NULL,
  `CurrentZone` varchar(255) DEFAULT NULL,
  `ZoneEntryTimestamp` varchar(255) DEFAULT NULL,
  `CurrentShelter` varchar(255) DEFAULT NULL,
  `OperatorAuthorisation` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `Positions` (
  `ID` varchar(255) NOT NULL,
  `Type` varchar(255) NOT NULL,
  `PositionName` varchar(255) NOT NULL,
  `Department` varchar(255) NOT NULL,
  `Phone` varchar(255) DEFAULT NULL,
  `Mobil` varchar(255) DEFAULT NULL,
  `Radio` varchar(255) DEFAULT NULL,
  `OwnerAccessCard` varchar(255) DEFAULT NULL,
  `Owner` varchar(255) DEFAULT NULL,
  `SuccessorAccessCard` varchar(255) DEFAULT NULL,
  `Successor` varchar(255) DEFAULT NULL,
  `Notes` text DEFAULT NULL,
  `RequiredSecurityClearance` varchar(255) DEFAULT NULL,
  `RestrictedZoneAuthorisation` varchar(255) DEFAULT NULL,
  `ExtraFunction` varchar(255) DEFAULT NULL,
  UNIQUE KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `Shelters` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL,
  `Coordinates` varchar(255) DEFAULT NULL,
  `Phone` varchar(255) DEFAULT NULL,
  `Radio` varchar(255) DEFAULT NULL,
  `QuickQty` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `SystemExtraFunctions` (
  `FunctionName` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `SystemExtraFunctions` VALUES('Kategorie-Personal');
INSERT INTO `SystemExtraFunctions` VALUES('Unterstützungs-Personal');
INSERT INTO `SystemExtraFunctions` VALUES('MASCAL-Personal');


CREATE TABLE `SystemNationalities` (
  `Nationality` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `SystemNationalities` VALUES('Deutsch (DE)');
INSERT INTO `SystemNationalities` VALUES('Französisch (FR)');
INSERT INTO `SystemNationalities` VALUES('Spanisch (ES)');
INSERT INTO `SystemNationalities` VALUES('Italienisch (IT)');
INSERT INTO `SystemNationalities` VALUES('Britisch (GB)');
INSERT INTO `SystemNationalities` VALUES('Polnisch (PL)');
INSERT INTO `SystemNationalities` VALUES('Niederländisch (NL)');
INSERT INTO `SystemNationalities` VALUES('Belgisch (BE)');
INSERT INTO `SystemNationalities` VALUES('Schweizerisch (CH)');
INSERT INTO `SystemNationalities` VALUES('Österreichisch (AT)');
INSERT INTO `SystemNationalities` VALUES('Schwedisch (SE)');
INSERT INTO `SystemNationalities` VALUES('Norwegisch (NO)');
INSERT INTO `SystemNationalities` VALUES('Dänisch (DK)');
INSERT INTO `SystemNationalities` VALUES('Finnisch (FI)');
INSERT INTO `SystemNationalities` VALUES('Russisch (RU)');
INSERT INTO `SystemNationalities` VALUES('Griechisch (GR)');
INSERT INTO `SystemNationalities` VALUES('Portugiesisch (PT)');
INSERT INTO `SystemNationalities` VALUES('Irisch (IE)');
INSERT INTO `SystemNationalities` VALUES('Tschechisch (CZ)');
INSERT INTO `SystemNationalities` VALUES('Ungarisch (HU)');
INSERT INTO `SystemNationalities` VALUES('Slowakisch (SK)');
INSERT INTO `SystemNationalities` VALUES('Slowenisch (SI)');
INSERT INTO `SystemNationalities` VALUES('Kroatisch (HR)');
INSERT INTO `SystemNationalities` VALUES('Bosnisch (BA)');
INSERT INTO `SystemNationalities` VALUES('Serbisch (RS)');
INSERT INTO `SystemNationalities` VALUES('Montenegrinisch (ME)');
INSERT INTO `SystemNationalities` VALUES('Mazedonisch (MK)');
INSERT INTO `SystemNationalities` VALUES('Albanisch (AL)');
INSERT INTO `SystemNationalities` VALUES('Bulgarisch (BG)');
INSERT INTO `SystemNationalities` VALUES('Rumänisch (RO)');
INSERT INTO `SystemNationalities` VALUES('Ukrainisch (UA)');
INSERT INTO `SystemNationalities` VALUES('Weißrussisch (BY)');
INSERT INTO `SystemNationalities` VALUES('Litauisch (LT)');
INSERT INTO `SystemNationalities` VALUES('Lettisch (LV)');
INSERT INTO `SystemNationalities` VALUES('Estnisch (EE)');
INSERT INTO `SystemNationalities` VALUES('Isländisch (IS)');
INSERT INTO `SystemNationalities` VALUES('Maltesisch (MT)');
INSERT INTO `SystemNationalities` VALUES('Luxemburgisch (LU)');
INSERT INTO `SystemNationalities` VALUES('Liechtensteinisch (LI)');
INSERT INTO `SystemNationalities` VALUES('Andorranisch (AD)');
INSERT INTO `SystemNationalities` VALUES('Monegassisch (MC)');
INSERT INTO `SystemNationalities` VALUES('San-Marinesisch (SM)');
INSERT INTO `SystemNationalities` VALUES('Vatikanisch (VA)');
INSERT INTO `SystemNationalities` VALUES('Ägyptisch (EG)');
INSERT INTO `SystemNationalities` VALUES('Südafrikanisch (ZA)');
INSERT INTO `SystemNationalities` VALUES('Nigerianisch (NG)');
INSERT INTO `SystemNationalities` VALUES('Äthiopisch (ET)');
INSERT INTO `SystemNationalities` VALUES('Kenianisch (KE)');
INSERT INTO `SystemNationalities` VALUES('Tansanisch (TZ)');
INSERT INTO `SystemNationalities` VALUES('Marokkanisch (MA)');
INSERT INTO `SystemNationalities` VALUES('Algerisch (DZ)');
INSERT INTO `SystemNationalities` VALUES('Tunesisch (TN)');
INSERT INTO `SystemNationalities` VALUES('Ghanaisch (GH)');
INSERT INTO `SystemNationalities` VALUES('Angolanisch (AO)');
INSERT INTO `SystemNationalities` VALUES('Ivorisch (CI)');
INSERT INTO `SystemNationalities` VALUES('Senegalesisch (SN)');
INSERT INTO `SystemNationalities` VALUES('Simbabwisch (ZW)');
INSERT INTO `SystemNationalities` VALUES('Sambisch (ZM)');
INSERT INTO `SystemNationalities` VALUES('Namibisch (NA)');
INSERT INTO `SystemNationalities` VALUES('Botswanisch (BW)');
INSERT INTO `SystemNationalities` VALUES('Libysch (LY)');
INSERT INTO `SystemNationalities` VALUES('Sudanisch (SD)');
INSERT INTO `SystemNationalities` VALUES('Somalisch (SO)');
INSERT INTO `SystemNationalities` VALUES('Ruandisch (RW)');
INSERT INTO `SystemNationalities` VALUES('Ugandisch (UG)');
INSERT INTO `SystemNationalities` VALUES('Mosambikanisch (MZ)');
INSERT INTO `SystemNationalities` VALUES('Madagassisch (MG)');
INSERT INTO `SystemNationalities` VALUES('Kap-Verdisch (CV)');
INSERT INTO `SystemNationalities` VALUES('Mauritianisch (MU)');
INSERT INTO `SystemNationalities` VALUES('Seychellisch (SC)');
INSERT INTO `SystemNationalities` VALUES('Chinesisch (CN)');
INSERT INTO `SystemNationalities` VALUES('Indisch (IN)');
INSERT INTO `SystemNationalities` VALUES('Japanisch (JP)');
INSERT INTO `SystemNationalities` VALUES('Südkoreanisch (KR)');
INSERT INTO `SystemNationalities` VALUES('Nordkoreanisch (KP)');
INSERT INTO `SystemNationalities` VALUES('Vietnamesisch (VN)');
INSERT INTO `SystemNationalities` VALUES('Thailändisch (TH)');
INSERT INTO `SystemNationalities` VALUES('Philippinisch (PH)');
INSERT INTO `SystemNationalities` VALUES('Malaysisch (MY)');
INSERT INTO `SystemNationalities` VALUES('Indonesisch (ID)');
INSERT INTO `SystemNationalities` VALUES('Saudi-Arabisch (SA)');
INSERT INTO `SystemNationalities` VALUES('Iranisch (IR)');
INSERT INTO `SystemNationalities` VALUES('Irakisch (IQ)');
INSERT INTO `SystemNationalities` VALUES('Türkisch (TR)');
INSERT INTO `SystemNationalities` VALUES('Israelisch (IL)');
INSERT INTO `SystemNationalities` VALUES('Jordanisch (JO)');
INSERT INTO `SystemNationalities` VALUES('Syrisch (SY)');
INSERT INTO `SystemNationalities` VALUES('Libanesisch (LB)');
INSERT INTO `SystemNationalities` VALUES('Pakistanisch (PK)');
INSERT INTO `SystemNationalities` VALUES('Bangladeschisch (BD)');
INSERT INTO `SystemNationalities` VALUES('Afghanisch (AF)');
INSERT INTO `SystemNationalities` VALUES('Kasachisch (KZ)');
INSERT INTO `SystemNationalities` VALUES('Usbekisch (UZ)');
INSERT INTO `SystemNationalities` VALUES('Turkmenisch (TM)');
INSERT INTO `SystemNationalities` VALUES('Kirgisisch (KG)');
INSERT INTO `SystemNationalities` VALUES('Tadschikisch (TJ)');
INSERT INTO `SystemNationalities` VALUES('Georgisch (GE)');
INSERT INTO `SystemNationalities` VALUES('Armenisch (AM)');
INSERT INTO `SystemNationalities` VALUES('Aserbaidschanisch (AZ)');
INSERT INTO `SystemNationalities` VALUES('Mongolisch (MN)');
INSERT INTO `SystemNationalities` VALUES('Sri-Lankisch (LK)');
INSERT INTO `SystemNationalities` VALUES('Nepalesisch (NP)');
INSERT INTO `SystemNationalities` VALUES('Bhutanisch (BT)');
INSERT INTO `SystemNationalities` VALUES('Maledivisch (MV)');
INSERT INTO `SystemNationalities` VALUES('Amerikanisch (US)');
INSERT INTO `SystemNationalities` VALUES('Kanadisch (CA)');
INSERT INTO `SystemNationalities` VALUES('Mexikanisch (MX)');
INSERT INTO `SystemNationalities` VALUES('Kubanisch (CU)');
INSERT INTO `SystemNationalities` VALUES('Jamaikanisch (JM)');
INSERT INTO `SystemNationalities` VALUES('Haitianisch (HT)');
INSERT INTO `SystemNationalities` VALUES('Dominikanisch (DO)');
INSERT INTO `SystemNationalities` VALUES('Guatemaltekisch (GT)');
INSERT INTO `SystemNationalities` VALUES('Honduranisch (HN)');
INSERT INTO `SystemNationalities` VALUES('Salvadorianisch (SV)');
INSERT INTO `SystemNationalities` VALUES('Nicaraguanisch (NI)');
INSERT INTO `SystemNationalities` VALUES('Costa-Ricanisch (CR)');
INSERT INTO `SystemNationalities` VALUES('Panamaisch (PA)');
INSERT INTO `SystemNationalities` VALUES('Brasilianisch (BR)');
INSERT INTO `SystemNationalities` VALUES('Argentinisch (AR)');
INSERT INTO `SystemNationalities` VALUES('Chilenisch (CL)');
INSERT INTO `SystemNationalities` VALUES('Kolumbianisch (CO)');
INSERT INTO `SystemNationalities` VALUES('Peruanisch (PE)');
INSERT INTO `SystemNationalities` VALUES('Venezolanisch (VE)');
INSERT INTO `SystemNationalities` VALUES('Ecuadorianisch (EC)');
INSERT INTO `SystemNationalities` VALUES('Bolivianisch (BO)');
INSERT INTO `SystemNationalities` VALUES('Paraguayanisch (PY)');
INSERT INTO `SystemNationalities` VALUES('Uruguayanisch (UY)');
INSERT INTO `SystemNationalities` VALUES('Surinamisch (SR)');
INSERT INTO `SystemNationalities` VALUES('Guyanisch (GY)');
INSERT INTO `SystemNationalities` VALUES('Australisch (AU)');
INSERT INTO `SystemNationalities` VALUES('Neuseeländisch (NZ)');
INSERT INTO `SystemNationalities` VALUES('Fidschianisch (FJ)');
INSERT INTO `SystemNationalities` VALUES('Papua-Neuguineisch (PG)');
INSERT INTO `SystemNationalities` VALUES('Samoanisch (WS)');
INSERT INTO `SystemNationalities` VALUES('Tongaisch (TO)');
INSERT INTO `SystemNationalities` VALUES('Vanuatuisch (VU)');
INSERT INTO `SystemNationalities` VALUES('Kiribatisch (KI)');
INSERT INTO `SystemNationalities` VALUES('Marshallisch (MH)');
INSERT INTO `SystemNationalities` VALUES('Mikronesisch (FM)');



CREATE TABLE `SystemOptions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Option` varchar(255) NOT NULL,
  `Value` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `SystemOptions` VALUES('1', 'AlarmStatus', 'false');
INSERT INTO `SystemOptions` VALUES('2', 'AlarmType', 'SIRENENTEST');
INSERT INTO `SystemOptions` VALUES('3', 'AlarmMessage', 'Es besteht kein Handlungsbedarf.\n\nIncoming, Incoming, Incoming.\nSuchen Sie den nächstgelegenen Shelter auf.');



CREATE TABLE `SystemRanks` (
  `ShortRank` varchar(255) NOT NULL,
  `Rank` varchar(255) NOT NULL,
  UNIQUE KEY `ShortRank` (`ShortRank`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `SystemRanks` VALUES('ADM', 'Admiral');
INSERT INTO `SystemRanks` VALUES('ADMA', 'Admiralarzt');
INSERT INTO `SystemRanks` VALUES('ADMOSA', 'Admiraloberstabsarzt');
INSERT INTO `SystemRanks` VALUES('ADMSA', 'Admiralstabsarzt');
INSERT INTO `SystemRanks` VALUES('B', 'Bootsmann');
INSERT INTO `SystemRanks` VALUES('BG', 'Brigadegeneral');
INSERT INTO `SystemRanks` VALUES('F', 'Feldwebel');
INSERT INTO `SystemRanks` VALUES('FADM', 'Flottillenadmiral');
INSERT INTO `SystemRanks` VALUES('Fj', 'Fahnenjunker');
INSERT INTO `SystemRanks` VALUES('FK', 'Fregattenkapitän');
INSERT INTO `SystemRanks` VALUES('FLA', 'Flottenarzt');
INSERT INTO `SystemRanks` VALUES('FLAP', 'Flottenapotheker');
INSERT INTO `SystemRanks` VALUES('FR', 'Fähnrich');
INSERT INTO `SystemRanks` VALUES('FRZS', 'Fähnrich zur See');
INSERT INTO `SystemRanks` VALUES('FTLA', 'Flottillenarzt');
INSERT INTO `SystemRanks` VALUES('FTLAP', 'Flottillenapotheker');
INSERT INTO `SystemRanks` VALUES('G', 'Gefreiter');
INSERT INTO `SystemRanks` VALUES('GA', 'Generalarzt');
INSERT INTO `SystemRanks` VALUES('GAP', 'Generalapotheker');
INSERT INTO `SystemRanks` VALUES('GEN', 'General');
INSERT INTO `SystemRanks` VALUES('GL', 'Generalleutnant');
INSERT INTO `SystemRanks` VALUES('GM', 'Generalmajor');
INSERT INTO `SystemRanks` VALUES('GOSA', 'Generaloberstabsarzt');
INSERT INTO `SystemRanks` VALUES('GSA', 'Generalstabsarzt');
INSERT INTO `SystemRanks` VALUES('H', 'Hauptmann');
INSERT INTO `SystemRanks` VALUES('HB', 'Hauptbootsmann');
INSERT INTO `SystemRanks` VALUES('HF', 'Hauptfeldwebel');
INSERT INTO `SystemRanks` VALUES('HG', 'Hauptgefreiter');
INSERT INTO `SystemRanks` VALUES('K', 'Korporal');
INSERT INTO `SystemRanks` VALUES('KADM', 'Konteradmiral');
INSERT INTO `SystemRanks` VALUES('KK', 'Korvettenkapitän');
INSERT INTO `SystemRanks` VALUES('KL', 'Kapitänleutnant');
INSERT INTO `SystemRanks` VALUES('KZS', 'Kapitän zur See');
INSERT INTO `SystemRanks` VALUES('L', 'Leutnant');
INSERT INTO `SystemRanks` VALUES('LZS', 'Leutnant zur See');
INSERT INTO `SystemRanks` VALUES('M', 'Major');
INSERT INTO `SystemRanks` VALUES('MilPf', 'Militärpfarrer');
INSERT INTO `SystemRanks` VALUES('MT', 'Maat');
INSERT INTO `SystemRanks` VALUES('O', 'Oberst');
INSERT INTO `SystemRanks` VALUES('OB', 'Oberbootsmann');
INSERT INTO `SystemRanks` VALUES('OF', 'Oberfeldwebel');
INSERT INTO `SystemRanks` VALUES('OFA', 'Oberfeldarzt');
INSERT INTO `SystemRanks` VALUES('OFAP', 'Oberfeldapotheker');
INSERT INTO `SystemRanks` VALUES('OFR', 'Oberfähnrich');
INSERT INTO `SystemRanks` VALUES('OFRZS', 'Oberfähnrich zur See');
INSERT INTO `SystemRanks` VALUES('OFV', 'Oberfeldveterinär');
INSERT INTO `SystemRanks` VALUES('OG', 'Obergefreiter');
INSERT INTO `SystemRanks` VALUES('OL', 'Oberleutnant');
INSERT INTO `SystemRanks` VALUES('OLZS', 'Oberleutnant zur See');
INSERT INTO `SystemRanks` VALUES('OMT', 'Obermaat');
INSERT INTO `SystemRanks` VALUES('OSA', 'Oberstabsarzt');
INSERT INTO `SystemRanks` VALUES('OSAP', 'Oberstabsapotheker');
INSERT INTO `SystemRanks` VALUES('OSB', 'Oberstabsbootsmann');
INSERT INTO `SystemRanks` VALUES('OSF', 'Oberstabsfeldwebel');
INSERT INTO `SystemRanks` VALUES('OSG', 'Oberstabsgefreiter');
INSERT INTO `SystemRanks` VALUES('OSV', 'Oberstabsveterinär');
INSERT INTO `SystemRanks` VALUES('OTA', 'Oberstarzt');
INSERT INTO `SystemRanks` VALUES('OTAP', 'Oberstapotheker');
INSERT INTO `SystemRanks` VALUES('OTL', 'Oberstleutnant');
INSERT INTO `SystemRanks` VALUES('OTV', 'Oberstveterinär');
INSERT INTO `SystemRanks` VALUES('SA', 'Stabsarzt');
INSERT INTO `SystemRanks` VALUES('SAP', 'Stabsapotheker');
INSERT INTO `SystemRanks` VALUES('SB', 'Staabsbootsmann');
INSERT INTO `SystemRanks` VALUES('SF', 'Stabsfeldwebel');
INSERT INTO `SystemRanks` VALUES('SG', 'Stabsgefreiter');
INSERT INTO `SystemRanks` VALUES('SH', 'Stabshauptmann');
INSERT INTO `SystemRanks` VALUES('SK', 'Stabskorporal');
INSERT INTO `SystemRanks` VALUES('SKAD', 'Seekadett');
INSERT INTO `SystemRanks` VALUES('SKL', 'Stabskapitänleutnant');
INSERT INTO `SystemRanks` VALUES('SU', 'Stabsunteroffizier');
INSERT INTO `SystemRanks` VALUES('SV', 'Stabsveterinär');
INSERT INTO `SystemRanks` VALUES('U', 'Unteroffizier');
INSERT INTO `SystemRanks` VALUES('VADM', 'Vizeadmiral');



CREATE TABLE `ZonePermissions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ZoneID` int(11) NOT NULL,
  `AccountID` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `Zones` (
  `ZoneID` int(11) NOT NULL AUTO_INCREMENT,
  `ZoneName` varchar(255) NOT NULL,
  `ZoneColor` varchar(255) DEFAULT NULL,
  `Description` varchar(255) DEFAULT NULL,
  `ZoneOnExit` int(11) DEFAULT NULL,
  `Restricted` int(11) DEFAULT NULL,
  `AlarmAuthorisation` int(11) DEFAULT NULL,
  PRIMARY KEY (`ZoneID`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `Zones` VALUES('1', 'SONIC / RTV', '#4CAF50', NULL, '2', NULL, NULL);
INSERT INTO `Zones` VALUES('2', 'MSAB', '#6571FF', NULL, '4', NULL, NULL);
INSERT INTO `Zones` VALUES('3', 'Sperrzone', '#f79524', NULL, '1', '1', '1');
INSERT INTO `Zones` VALUES('4', 'Außerhalb MSAB', 'red', NULL, '2', NULL, NULL);

